/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.renderer.GlStateManager;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiTimerWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.util.Util;

public class CustomGuiTimer
extends GuiLabel
implements IGuiComponent {
    int colour;
    String[] hoverText;
    GuiCustom parent;
    float scale;
    private final long start;
    private final long now;
    private final long end;
    private final boolean reverse;
    private final FontRenderer fontRenderer;
    private int offsetType;
    private final int textColor;
    private final int[] offsets;

    public static CustomGuiTimer fromComponent(CustomGuiTimerWrapper component) {
        CustomGuiTimer timer = new CustomGuiTimer(component.start, component.end, component.reverse, component.getId(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), component.getColor());
        timer.setScale(component.getScale());
        if (component.hasHoverText()) {
            timer.hoverText = component.getHoverText();
        }
        return timer;
    }

    public CustomGuiTimer(long start, long end, boolean reverse, int id, int x, int y, int width, int height, int colour) {
        super(Minecraft.func_71410_x().field_71466_p, id, GuiCustom.guiLeft + x, GuiCustom.guiTop + y, width, height, colour);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.textColor = colour;
        this.offsetType = 0;
        this.scale = 1.0f;
        this.colour = colour;
        this.start = start;
        this.end = end;
        this.now = System.currentTimeMillis();
        this.reverse = reverse;
        this.offsets = new int[]{0, 0};
    }

    @Override
    public int getId() {
        return this.field_175204_i;
    }

    @Override
    public int[] getPosXY() {
        return new int[]{this.field_146162_g, this.field_146174_h};
    }

    public String getText() {
        long time = System.currentTimeMillis() - this.now;
        time /= 50L;
        if (this.reverse) {
            time = this.start - time;
        }
        if (time < 0L || !this.reverse && time > this.end) {
            NoppesUtilPlayer.sendDataCheckDelay(EnumPlayerPacket.HudTimerEnd, this, 250L, this.field_175204_i, this.offsetType);
        }
        if (this.reverse) {
            time += 20L;
        }
        return Util.instance.ticksToElapsedTime(time, false, false, false);
    }

    @Override
    public void offSet(int offsetType, double[] windowSize) {
        this.offsetType = offsetType;
        switch (offsetType) {
            case 1: {
                this.offsets[0] = 0;
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            case 2: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = 0;
                break;
            }
            case 3: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            default: {
                this.offsets[0] = 0;
                this.offsets[1] = 0;
            }
        }
    }

    @Override
    public void onRender(Minecraft mc, int mouseX, int mouseY, int mouseWheel, float partialTicks) {
        if (!this.field_146172_j) {
            return;
        }
        int x = this.offsets[0] == 0 ? this.field_146162_g : this.offsets[0] - this.field_146162_g - this.field_146167_a;
        int y = this.offsets[1] == 0 ? this.field_146174_h : this.offsets[1] - this.field_146174_h - this.field_146161_f;
        boolean hovered = mouseX >= x && mouseY >= y && mouseX < x + this.field_146167_a && mouseY < y + this.field_146161_f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)Math.min(this.field_175204_i, 1000));
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.func_73731_b(this.fontRenderer, this.getText(), 0, 0, this.textColor);
        if (hovered && this.hoverText != null && this.hoverText.length > 0) {
            this.parent.hoverText = this.hoverText;
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void setParent(GuiCustom parent) {
        this.parent = parent;
    }

    @Override
    public void setPosXY(int newX, int newY) {
        this.field_146162_g = newX;
        this.field_146174_h = newY;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public ICustomGuiComponent toComponent() {
        CustomGuiTimerWrapper component = new CustomGuiTimerWrapper(this.field_175204_i, this.start, this.end, this.field_146162_g, this.field_146174_h, this.field_146167_a, this.field_146161_f, this.colour);
        component.setHoverText(this.hoverText);
        return component;
    }
}

